//
//  GXTupleVariation.h
//  GSFontTools
//
//  Created by Georg Seifert on 30/03/17.
//
//

#import <Cocoa/Cocoa.h>

//#define TUPLES_SHARE_POINT_NUMBERS 0x8000
//#define TUPLE_COUNT_MASK 0x0fff
//
//#define EMBEDDED_TUPLE_COORD 0x8000
//#define INTERMEDIATE_TUPLE 0x4000
//#define PRIVATE_POINT_NUMBERS 0x2000
//#define TUPLE_INDEX_MASK 0x0fff
//
//#define DELTAS_ARE_ZERO 0x80
//#define DELTAS_ARE_WORDS 0x40
//#define DELTA_RUN_COUNT_MASK 0x3f
//
//#define POINTS_ARE_WORDS 0x80
//#define POINT_RUN_COUNT_MASK 0x7f

@class GSXMLWriter;
@class TTFont;
@class FTPointArray;

@interface GXTupleVariation : NSObject

@property (nonatomic, retain) NSDictionary *axes;
@property (nonatomic, retain) FTPointArray *coordinates;

- (instancetype)initWithAxis:(NSDictionary *)axis coordinates:(FTPointArray *)coordinates;
// def __init__(self, axes, coordinates):

+ (NSArray *)decompileTuples:(NSData *)data axisTags:(NSArray *)axisTags numTuples:(NSUInteger)numTuples pos:(NSUInteger *)pos;

+ (NSArray *)decompileSharedTuples:(NSData *)data axisTags:(NSArray *)axisTags sharedTupleCount:(NSUInteger)sharedTupleCount pos:(NSUInteger *)pos;

+ (NSArray *)decompileTupleVariationStore:(NSData *)data tableTag:(NSString *)tableTag axisTags:(NSArray *)axisTags tupleVariationCount:(NSUInteger)tupleVariationCount pointCount:(NSUInteger)pointCount sharedTuples:(NSArray *)sharedTuples pos:(NSUInteger)pos dataPos:(NSUInteger)dataPos;

//+ (NSDictionary *)decompileTuple:(NSData*)data axisTags:(NSArray *)axisTags pos:(NSUInteger*)pos;

+ (NSArray *)decompilePoints:(NSData *)data pointCount:(NSUInteger)pointCount pos:(NSUInteger *)pos;

+ (NSArray *)decompileDeltas:(NSData *)data numDeltas:(NSUInteger)numDeltas pos:(NSUInteger *)pos;

+ (BOOL)compileTupleVariationStore:(NSMutableData *)data tupleData:(NSMutableData *)tupleData tupleCount:(NSUInteger *)tupleCount variations:(NSArray *)variations pointCount:(NSUInteger)pointCount axisTags:(NSArray *)axisTags sharedTupleIndices:(NSDictionary *)sharedTupleIndices error:(NSError **)error;

+ (NSArray *)compileSharedTuples:(NSArray *)axisTags variations:(NSArray *)variations;

- (BOOL)compile:(NSMutableData *)tupleData auxData:(NSMutableData *)auxData axisTags:(NSArray *)axisTags sharedTupleIndices:(NSDictionary *)sharedTupleIndices sharedPoints:(NSIndexSet *)sharedPoints usesSharedPoints:(BOOL *)usesSharedPoints error:(NSError **)error;

- (NSData *)compileIntermediateCoord:(NSArray *)axisTags;
+ (NSArray *)computeMinMaxTuple:(NSDictionary *)tuple;
- (BOOL)hasImpact;

//+ (NSDictionary*)decompileTuple:(NSData*)data axisTags:(NSArray *)axisTags pos:(NSUInteger*)pos;
//+ (NSArray *)decompileCoords:(NSData*)data axisTags:(NSArray *)axisTags numCoords:(NSUInteger)numCoords pos:(NSUInteger*)pos;
//+ (NSArray *)decompileDeltas:(NSData*)data numDeltas:(NSUInteger)numDeltas pos:(NSUInteger*)pos;

+ (NSUInteger)tupleSizeForFlags:(NSUInteger)flags axisCount:(NSUInteger)axisCount;

- (NSData *)compileCoord:(NSArray *)axisTags;

//- (NSData*)compileIntermediateCoord:(NSArray *)axisTags;
+ (NSData *)compilePoints:(NSIndexSet *)points pointCount:(NSUInteger)pointCount;

- (void)toXML:(GSXMLWriter *)writer font:(TTFont *)font;
@end
